#!/usr/bin/env python

# Edit Column Options
# Copyright 2004 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 040715 - first version of this script
# 040902 - added edit for column label
# 050912 - Alex - get the column list from GanttReport
# 080610 - Alex - allow the user to turn on actual and base bars

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

class GanttOptionsDialog(wx.Dialog):
    def __init__(self, parent, rc):
        wx.Dialog.__init__(self, parent, -1, 'Edit Column Options')
        self.rc = rc
        periods = rc.Periods or 1
        bars = rc.Bars or 'p'

        border_sizer = wx.BoxSizer(wx.HORIZONTAL)
        sizer = wx.BoxSizer(wx.VERTICAL)

        period_label = wx.StaticText(self, -1, "Number of time periods:")
        self.period_ctrl = wx.TextCtrl(self, -1, str(periods), size=(60, 25))

        grid_sizer = wx.FlexGridSizer(0, 1, hgap=10, vgap=5)
        grid_sizer2 = wx.FlexGridSizer(1, 0, hgap=10, vgap=5)
        grid_sizer2.Add(period_label, 0, wx.ALIGN_CENTER_VERTICAL)
        grid_sizer2.Add(self.period_ctrl, 0, wx.ALIGN_RIGHT)
        grid_sizer.Add(grid_sizer2)

        grid_sizer.Add((10, 10))

        self.planbar_ctrl = wx.CheckBox(self, -1, "Show Plan Bar")
        self.planbar_ctrl.SetValue('p' in bars or 'c' in bars or 'C' in bars)
        grid_sizer.Add(self.planbar_ctrl, 0, wx.ALIGN_CENTER_VERTICAL)

        self.completionbar_ctrl = wx.CheckBox(self, -1, "Show Completion")
        self.completionbar_ctrl.SetValue('c' in bars or 'C' in bars)
        grid_sizer.Add(self.completionbar_ctrl, 0, wx.ALIGN_CENTER_VERTICAL | wx.LEFT, 25)

        self.actualbar_ctrl = wx.CheckBox(self, -1, "Show Actual Bar")
        self.actualbar_ctrl.SetValue('a' in bars)
        grid_sizer.Add(self.actualbar_ctrl, 0, wx.ALIGN_CENTER_VERTICAL)

        self.basebar_ctrl = wx.CheckBox(self, -1, "Show Base Bar")
        self.basebar_ctrl.SetValue('b' in bars)
        grid_sizer.Add(self.basebar_ctrl, 0, wx.ALIGN_CENTER_VERTICAL)

        sizer.Add(grid_sizer)
        sizer.Add((10, 10))

        buttons = wx.BoxSizer(wx.HORIZONTAL)
        cancelbutton = wx.Button(self, wx.ID_CANCEL, "Cancel", size=(70, 20))
        buttons.Add(cancelbutton, 0, wx.ALIGN_CENTER_VERTICAL)
        okbutton = wx.Button(self, wx.ID_OK, "OK", size=(70, 20))
        okbutton.SetDefault()
        buttons.Add((10, 10))
        buttons.Add(okbutton, 0, wx.ALIGN_CENTER_VERTICAL)
        sizer.Add(buttons, 0, wx.ALIGN_RIGHT)

        border_sizer.Add(sizer, 0, wx.ALL | wx.ALIGN_CENTRE, 10)
        self.SetSizer(border_sizer)
        self.Fit()
        self.CentreOnScreen()

        self.UpdateChecks()
        wx.EVT_BUTTON(self, wx.ID_OK, self.OnOK)
        wx.EVT_CHECKBOX(self, -1, self.OnCheck)

    def UpdateChecks(self):
        self.completionbar_ctrl.Enable(self.planbar_ctrl.GetValue())

    def OnCheck(self, event):
        self.UpdateChecks()
        event.Skip()

    def OnOK(self, event):
        try:
            newvalue = int(self.period_ctrl.GetValue())
        except ValueError:
            pass
        else:
            if newvalue < 1:
                newvalue = 1
            self.rc.Periods = newvalue
        bars = ""
        if self.planbar_ctrl.GetValue():
            if self.completionbar_ctrl.GetValue():
                bars += "c"
            else:
                bars += "p"
        if self.actualbar_ctrl.GetValue():
            bars += "a"
        if self.basebar_ctrl.GetValue():
            bars += "b"
        self.rc.Bars = bars
        Data.SetUndo('Edit Column Options')
        event.Skip()

def UpdateColumn(self):
    sel = self.Report.GetSelectedCols()  # current selection
    if not sel:
        hint("Select a column first.")
        return

    columns = self.Report.table.columns
    s = sel[0]
    cid = columns[s]

    sel_cids = [columns[s] for s in sel]
    if sel_cids.count(cid) != len(sel_cids):
        hint("Select only one column.")
        return

    c = Data.Database['ReportColumn'][cid]
    ctid = self.Report.table.ctypes[s]
    ct = Data.Database['ColumnType'][ctid]

    if ct.get('AccessType') == 's':
        periods = c.get('Periods') or 1
        rc_object = Data.DBObject.GetObject('ReportColumn', cid)
        dlg = GanttOptionsDialog(None, rc_object)
        dlg.ShowModal()
    else:
        # allow edit of column label
        # should allow two rows -- do this later
        ctype = ct.get('Label') or ct.get('Name') or "-"
        default = ctype.replace("\n", r"\n")
        msg = 'Defaults to column type: "' + default + '"\nUse ' + r'"\n"' + " to separate lines."
        label = c.get('Label') or ""
        oldvalue = label.replace("\n", r"\n") or default
        dlg = wx.TextEntryDialog(None, msg, 'Edit Column Label', oldvalue)
        dlg.SetValue(oldvalue)
        if dlg.ShowModal() == wx.ID_OK:
            newvalue = dlg.GetValue().replace(r"\n", "\n")
            if newvalue != label:
                change = {'Table': 'ReportColumn', 'ID': cid, 'Label': newvalue}
                Data.Update(change)
                Data.SetUndo('Edit Column Label')
        dlg.Destroy()

UpdateColumn(self)
